<!-- Version SVN: $Id: _related.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<div id="media-related-list">
  <?php $c = 0; $cmax = $related_pager->getNBResults() - 1; ?>
  <?php if ($cmax >= 0) : ?>
  <?php foreach($related_pager->getResults() as $related) :  ?>
  <a href="<?php print url_for($related->getLink()); ?>" class="furthvid">
    <?php print image_tag($related->getThumbnail(array('size' => '120x90')), array('class' => 'thumb', 'width' => 120, 'height' => 90, 'alt' => $related->getTitle(), 'title' => $related->getTitle())); ?>
    <h2><?php print $related->getTitle(); ?></h2>
    <span><?php print truncate_text(strip_tags($related->getDescription()), 200, '<span class="red">[...]</span>'); ?></span>
    <div class="clear_l"></div>
  </a>
  <?php $c++; ?>
  <?php endforeach; ?>
  <?php else : ?>
  <p class="empty"><?php print __('No related media found.') ?></p>
  <?php endif; ?>
</div>
<?php if($showPager && $related_pager->haveToPaginate() && $related_pager->getLastPage() > $related_pager->getPage()) : ?>
<div id="further_media">
<?php
  $ajaxLink = 'media/ajax?component=related';
  $params = array(
    'key'         => $media->getMediaKey(),
    'show_pager'  => $showPager,
    'per_page'    => $perPage,
  );
  $ajaxLink.= (strpos($ajaxLink, '?') === false ? '?' : '&').'vars='.urlencode(serialize($params)).'&relpg='.($related_pager->getPage()+1);
  print dojo_link_to_remote(
    '<strong>'.__('Further media').'</strong>', 
    array(
      'url' => $ajaxLink, 
      'update'  => array('success' => 'meta-related'),
      'success' => array(
        'before' => "var listName = 'media-related-list'; var oldEntries = dojo.clone(dojo.byId(listName));", 
        'after' => "var newEntries = dojo.clone(dojo.byId(listName)); dojo.place(oldEntries, listName, 'replace'); dojo.forEach(newEntries.getChildren(), dojo.partial(function(listName, node) { dojo.place(node, listName, 'bottom'); }, listName));"
      )
    ), 
    array('href' => 'javascript: void(0);', "class" => "red")
  );
?>
</div>
<?php endif;?>
