<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<!-- Version SVN: $Id: layout.php 734 2012-03-22 18:22:01Z sven.poeche $ -->
<head>
<?php include_http_metas(); ?>
<?php include_metas(); ?>
<?php include_title(); ?>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<link rel="shortcut icon" href="/favicon.ico" />
<?php if(has_slot('facebookPreview')): ?>
<link rel="image_src" href="<?php include_slot('facebookPreview'); ?>" />
<?php endif; ?>
<?php if (stConfig::get('google_analytics_id')): ?>
<?php include_partial('start/googleAnalytics', array('id' => stConfig::get('google_analytics_id'), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
<?php endif; ?>
<script type="text/javascript" src="/js/mobile.js"></script>
</head>

<body>
  <div id="header">
    <?php print link_to(image_tag(stConfig::get('portal_logo_mobile'), array('id' => 'logo', 'width' => 91, 'height' => 28)), "@homepage"); ?>
    <a class="headerbtn" href="javascript: void(0);;"<?php print $sf_params->get('module') != 'search' ? ' onclick="showSearch();' : null; ?>">
      <img src="/images/btn_head_search.png" alt="<?php print __('Search'); ?>" width="35" height="31" />
    </a>
    <a class="headerbtn" href="<?php print url_for('default/vcenter'); ?>">
      <img src="/images/btn_head_vcenter.png" alt="<?php print __('ViMP ControlCenter'); ?>" width="35" height="31" />
    </a>
  </div>
  <div class="clear_r"></div>

  <div id="content">
<?php if($sf_params->get('module') != 'search') : ?>
    <form method="post" action="<?php print url_for('search/index'); ?>" id="searchfield">
      </span><input type="text" maxlength="128" id="searchstring"name="search" />
      <input type="submit" id="btn_submit" value="<?php print __('Search'); ?>" />
    </form>
<?php endif; ?>
    <?php include_partial("start/messages", array('user' => $sf_context->getUser(), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
    <?php echo $sf_content; ?>
    <?php include_partial('start/loginButton', array('culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
  <div id="footer">
    <div class="fl_l">
      <span><?php print link_to(__('Language'), 'user/language', array('class' => 'footerlink')); ?></span>
      <span><?php print link_to(__('Desktop'), 'default/desktop', array('class' => 'footerlink')); ?></span>
      <span class="seperator">&#149;</span>
      <span><?php print link_to(__('Privacy Policy'), WebContentPeer::getLink(stConfig::get('webcontent_static_privacy')), array('class' => 'footerlink')); ?></span>
      <span><?php print link_to(__('Terms of Use'), WebContentPeer::getLink(stConfig::get('webcontent_static_terms')), array('class' => 'footerlink')); ?></span>
      <span><?php print link_to(__('Disclaimer'), WebContentPeer::getLink(stConfig::get('webcontent_static_disclaimer')), array('class' => 'footerlink')); ?></span>
    </div>
    <div class="clear_b"></div>
  </div>

<?php dojo_includes(); ?>

  <script type="text/javascript">
    //iphone hide toolbar
    dojo.addOnLoad(function() {
      setTimeout(scrollTo, 0, 0, 1);
    });
<?php if(sfConfig::get("sf_environment") == "dev") : ?>
    dojo.addOnLoad(function() {
      if(typeof sfWebDebugToggleMenu != 'undefined') {
        sfWebDebugToggleMenu();
      }
    });
<?php endif; ?>
  </script>
</body>

</html>