<!-- Version SVN: $Id: _newBlogs.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<?php if($params['show_filter']) : ?>
<?php
  $filters = array(
    'all' => __('All'),
    'mine' => __('Mine'),
    'friends' => __('My friends\' blog entries'),
  );
?>
<form>
  <select name="filter" class="filter" onchange="<?php print str_replace('"#"', 'this.value', dojo_remote_function(array('url' => '#', 'update' => 'blogs-box'))); ?>">
<?php foreach($filters as $filterEntry => $filterCaption) : ?>
    <option value="<?php print url_for($ajaxLink.(strpos($ajaxLink, '?') === false ? '?' : '&').'filter='.$filterEntry); ?>"<?php print $params['filter'] == $filterEntry ? ' selected' : NULL; ?>><?php print $filterCaption; ?></option>
<?php endforeach; ?>
  </select>
</form>
<?php endif; ?>
<?php if($new_blogs_pager->getNbResults()>0): ?>
<div id="blogs-box-blogs-list">
<?php foreach($new_blogs_pager->getResults() as $blog): ?>
<div class="blog">
  <a href="<?php print url_for($blog->getLink()); ?>">
    <h2 class="red"><?php print $blog->getTitle(); ?></h2>
    <p><?php print __('from: @user', array('@user' => content_tag('span', $blog->getUser()->getName(), array('class' => 'red')))); ?></p>
    <p><?php print __('Date'); ?>: <span><?php print format_date($blog->getCreatedAt(null), 'd'); ?> - <?php print format_date($blog->getCreatedAt(null), 'q'); ?></span></p>
    <p><?php print __('Comments'); ?>: <span><?php print $blog->countBlogComments(); ?></span></p>
    <div class="blog_preview"><?php print truncate_text(strip_tags($blog->getDescription()), 200, '<span class="red">[...]</span>'); ?></div>
  </a>
</div>
<?php endforeach; ?>
</div>
<?php if($params['show_pager'] && $new_blogs_pager->haveToPaginate() && $new_blogs_pager->getLastPage() > $new_blogs_pager->getPage()): ?>
<div id="further_blogs">
<?php
  $ajaxLink.= (strpos($ajaxLink, '?') === false ? '?' : '&').'nbpg='.($new_blogs_pager->getPage()+1);
  print dojo_link_to_remote(
    '<strong>'.__('Further blogs').'</strong>', 
    array(
      'url' => $ajaxLink, 
      'update'  => array('success' => 'blogs-box'),
      'success' => array(
        'before' => "var listName = 'blogs-box-blogs-list'; var oldEntries = dojo.clone(dojo.byId(listName));", 
        'after' => "var newEntries = dojo.clone(dojo.byId(listName)); dojo.place(oldEntries, listName, 'replace'); dojo.forEach(newEntries.getChildren(), dojo.partial(function(listName, node) { dojo.place(node, listName, 'bottom'); }, listName));"
      )
    ), 
    array('href' => 'javascript: void(0);', "class" => "red")
  );
?>
</div>
<?php endif; ?>
<?php else: ?>
<p class="empty"><?php print __('No blog found.'); ?></p>
<?php endif; ?>
