<!-- Version SVN: $Id: viewSuccess.php 761 2012-04-05 19:40:35Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<?php if($user->isMyself()) : ?>
<h1><?php print __('My profile');?></h1>
<?php else : ?>
<h1><?php print __('User');?></h1>
<?php endif; ?>

<div class="box-w user clearfix">
  <?php include_component("user", "viewUser", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
</div>

<dl class="box-w user clearfix">
  <?php if($user->getDescription()): ?>
    <dd><?php print __('About me:');?></dd>
    <dt><?php print $user->getDescription(); ?></dt>
  <?php endif; ?>
</dl>

<div class="col-l">
  <div id="guestbook_content">
    <?php if(stToolkit::moduleEnabled('fbcomments') && stConfig::get('fbco_enabled')) : ?>
    <?php include_component('fbcomments', 'comments', array('width'=> 500, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
    <?php else : ?>
    <?php include_component("user", "viewGuestbook", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
    <?php endif; ?>
  </div>
</div>

<div class="col-r">

  <div id="mediaProfile" class="box-s clearfix">
      <?php include_component("media", "viewMedia", array(
            'for_object'         => 'User',
            'object_id'          => $user->getUid(),
            'thumbsize'          => '200x112',
            'items_perpage'       => stConfig::get('user_media_perpage'),
            'caption'            => __('Media'),
            'show_all_link'      => 'user/viewMyMedia?username='.$user->getUsername().'&uid='.$user->getUid(),
            'culture'            => sfContext::getInstance()->getUser()->getCulture()
          )); ?>
  </div>

<?php if(stToolkit::moduleEnabled('friends') && stConfig::get('enable_friends')) : ?>
  <div id="my_friends_content" class="box-s clearfix">
      <?php include_component("friends", "myFriends", array(
                    'user'           => $user,
                    'thumbsize'      =>'95x95',
                    'show_all_link'  => 'friends/index?user='.$user->getUsername(),
                    'culture'        => sfContext::getInstance()->getUser()->getCulture(),
                    'per_page'       => stConfig::get('user_friends_perpage'),
                  )); ?>
  </div>
<?php endif; ?>

<?php if(stToolkit::moduleEnabled('album') && stConfig::get('enable_album')) : ?>
  <div id="user-albums" class="box-s clearfix">
    <?php include_component("album", "user", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
<?php endif; ?>

<?php if(stToolkit::moduleEnabled('group') && stConfig::get('enable_groups')) : ?>
    <?php include_component("user", "groups", array(
            'user' => $user,
      'truncate_title' => 15,
            'culture' => sfContext::getInstance()->getUser()->getCulture()
          )); ?>
<?php endif; ?>

  <div id="user-favorites" class="box-s clearfix">
    <?php include_component("user", "favorites", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>

<?php if(stToolkit::moduleEnabled('blog') && stConfig::get('enable_blog')) : ?>
  <div id="my_blog_content" class="box-s clearfix">
      <?php include_component("blog", "newBlogs", array(
                    'user'              => $user,
                    'caption'            => __('Blogs'),
                    'truncate_title'    => 35,
                    'truncate_descr'    => 65,
                    'show_all_link'     => 'user/viewMyBlogs?username='.$user->getUsername(),
                    'show_more_link'    => true,
                    'show_user_info'    => false,
                    'show_pager'        => false,
                    'items_perpage'     => stConfig::get('user_blog_perpage'),
                    'culture'           => sfContext::getInstance()->getUser()->getCulture()
                  )); ?>
  </div>
<?php endif; ?>

    <?php /*
<?php if(stToolkit::moduleEnabled('community') && stConfig::get('enable_community')) : ?>
        <div id="history" class="box-s">
      <h2><?php print __("History of @user", array('@user' => $user->getLinkTo())); ?></h2>
      <?php include_component("community", "history", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
<?php endif; ?>
         */ ?>

  <?php if(stToolkit::moduleEnabled('googlemap') && stConfig::get('google_maps_key') && stConfig::get('google_maps_user')) : ?>
      <?php include_component('googlemap', 'boxSmall', array('type' => 'user', 'id' => $user->getUid(), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  <?php endif; ?>

</div>
