<?php

/**
 * This file is part of the ViMP Framework package.
 * (c) ViMP GmbH <info@vimp.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @package     framework
 * @subpackage
 * @author      ViMP GmbH
 * @version     SVN: $Id: _viewVisitors.php 2 2011-06-28 20:23:44Z sven.poeche $
 */
?>
<div class="box1" id="visitors">
  <div class="inner">
    <h2>
      <?php echo __("Your profile has been visited by") ?>
    </h2>
    <ul class="content user">
    <?php foreach($viewer_pager->getResults() as $vf): ?>
      <li>
        <?php include_component('user', 'avatar', array('user' => $vf->getUserRelatedByViewerUid(), 'options' => array('size' => '48x36'), 'show_overlay' => false)); ?>
        <p class="clearfix">
        <strong><?php print $vf->getUserRelatedByViewerUid()->getLinkTo() ?></strong>
        <span class="about">
          <?php print "(". $vf->getViewerCount().")" ?><br />
          <?php print __("Last visit: @date", array('@date' => format_datetime($vf->getLatestView(null)))) ?>
        </span>
        </p>
      </li>
    <?php endforeach ?>
    </ul>
    <?php if($viewer_pager->haveToPaginate()) : ?>
    <div class="bottomlink">
    <?php include_component('media', 'pager', array('short' => 'true', 'pager' => $viewer_pager, 'link' => "user/view?id=".$user->getUid(), 'perPage' => stConfig::get('user_visitors_perpage'), 'caption' => __("Visitor"), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
    </div>
    <?php endif; ?>
  </div>
</div>
