<!-- Version SVN: $Id: _viewUser.php 2 2011-06-28 20:23:44Z sven.poeche $ -->

<?php if(stToolkit::moduleEnabled('friends') && stConfig::get('enable_friends') && !$user->isMyself() && $user->isInvitedFriend($sf_user)): ?>
   <?php include_partial('friends/confirm', array('fid' => $user->getFriendshipId($sf_user))); ?>
<?php endif; ?>

<div class="box-w">
  
	<div class="content profile clearfix">
        <div class="avi">
          <?php include_component('user', 'avatar', array('user' => $user, 'options' => array('size' => '180x180'), 'linked' => false)); ?>
        </div>
		<div id="info">
      		<h2 class="title"><?php print $user->getUsername(); ?></h2>
      		<ul>
                <li><?php print $user->getCity(); ?> / <?php echo stToolkit::getCountry($user->getCountry()) ?></li>
                <li><?php print __('Age: @age', array('@age' => $user->getAge())); ?></li>
                <li><?php print __('@gender', array('@gender' => $user->getGender() ? ($user->getGender() == 'male' ? __('male') : __('female')) : __('not specified'))); ?></li>        
                <li><?php print __('Profile views: @Count', array("@Count" => $user->getCountViews())); ?></li>
                <li><?php print __('Last Login: @timediff', array('@timediff'=> st_simple_time_ago_in_words($loginTimestamp))); ?></li>        
                <li><?php print __('Registered: @timediff', array('@timediff'=> st_simple_time_ago_in_words($registered))); ?></li>        
			</ul>
		</div>
        
    	<ul class="actions">
        <?php if($user->canEdit()) : ?>
          <li><?php print link_to(__('Edit'), $user->getLinkEdit(), array('class' => 'edit')); ?></li>
        <?php endif; ?>
        <?php if(stToolkit::moduleEnabled('newsletterFrontend') && stConfig::get('enable_openid') && $user->canEdit()) : ?>
          <li><?php print link_to(__('Newsletters'), 'newsletterFrontend/index'.(!$user->isMyself() ? '?uid='.$user->getUid() : ''), array('id' => 'newsletters')); ?></li>
        <?php endif;?>
        <?php if(stToolkit::moduleEnabled('openid') && stConfig::get('enable_openid') && $user->isMyself()) : ?>
          <li><?php print link_to(__('OpenIDs'), 'openid/list', array('id' => 'openid_link')); ?></li>
        <?php endif;?>
        <?php if($user->canChangePassword()) : ?>
          <li><?php print link_to(__('Change password'), "user/changePassword".(!$user->isMyself() ? '?user='.$user->getUsername(): ''), array('class' => 'pw')); ?></li>
        <?php endif ?>
        <?php if(!$user->isMyself()) : ?>
        <?php if (stToolkit::moduleEnabled('pm') && stConfig::get('enable_pm') && $sf_user->getUser()->getStatus() == User::STATUS_REGISTERED): ?>
          <li><?php print link_to(__('Send a PM'), "pm/new?username=".$user->getUsername(), array('class' => 'pn')); ?></li>
        <?php endif; ?>
        <?php if (stToolkit::moduleEnabled('friends') && stConfig::get('enable_friends')): ?>
        <?php if(!$isFriend && $sf_user->getUser()->getStatus() == User::STATUS_REGISTERED) : ?>
          <li><?php print link_to(__('Add this friend'), "friends/invite?id=".$user->getUid(), array('class' => 'add')); ?></li>
        <?php elseif($isFriend && !$isFriendDenied) : ?>
          <li><?php print link_to(__('Delete this friend'), "friends/deleteFriend?fid=".$fid, array('class' => 'deleteFriend'), array('post' => false, 'confirm' => __('Are you sure you want to remove this user from your friends list?'))); ?></li>
        <?php endif; ?>
        <?php endif; ?>
        <?php endif; ?>
        <?php if($user->canFlag()) : ?>
          <li><?php print link_to( __('Report user'), $user->getLinkFlag(), array('title' => __('Report user'))) ?></li>
        <?php endif; ?>
        <?php if($user->isMyself() && $user->canDelete()): ?>
          <li><?php echo link_to(__('Delete this account'), 'user/deleteProfile', array('confirm' =>  __('Are you really sure?'))); ?></li>
        <?php endif; ?>
        <?php if(!$user->isMyself() && $user->canDelete()): ?>
          <li><?php echo link_to(__('Delete user'), 'user/delete?uid='.$user->getUid()); ?></li>
        <?php endif; ?>
    	</ul>        
        
	</div>
        <?php if($sf_context->getModuleName().'/'.$sf_context->getActionName() != 'user/view'): ?>
           <?php echo link_to(__('back to profile'), 'user/view?user='.$user->getUsername().'&uid='.$user->getUid(), array('class' => 'back')); ?>
        <?php endif; ?>
</div>
