<?php

/**
 * This file is part of the ViMP Framework package.
 * (c) ViMP GmbH <info@vimp.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @package     framework
 * @subpackage
 * @author      ViMP GmbH
 * @version     SVN: $Id: _viewNewMedia.php 2 2011-06-28 20:23:44Z sven.poeche $
 */

?>
<?php if(stConfig::get('enable_video') || stConfig::get('enable_photo') || stConfig::get('enable_audio') || stConfig::get('enable_document')) : ?>
<div id="latest-media">
<?php if(stConfig::get('enable_video')) : ?>
<div id="latest-videos" class="box1 small">
  <div class="inner">
    <h2><?php print __("My latest video") ?></h2>
    <div class="content">
    <?php if($video->isNew()): ?>
      <?php print image_tag("no_videos.png", array('alt' => "Keine Videos vorhanden", 'size' => '160x120')) ?>
      <?php else: ?>
      <?php print link_to(image_tag($video->getThumbnail(array('size' => '160x120')), array('alt' => $video->getTitle(), 'size' => '160x120')), $video->getLink(), array('class' => 'avatar')) ?>
    <?php endif ?>
    </div>
  </div>
</div>
<?php endif; ?>
<?php if(stConfig::get('enable_photo')) : ?>
<div id="latest-photos" class="box1 small">
  <div class="inner">
    <h2><?php print __("My latest picture") ?></h2>
    <div class="content">
    <?php if($photo->isNew()): ?>
      <?php print image_tag("no_photos.png", array('alt' => "Keine Photos vorhanden", 'size' => '160x120')) ?>
    <?php else: ?>
      <?php print link_to(image_tag($photo->getThumbnail(array('size' => '160x120')), array('alt' => $photo->getTitle(), 'size' => '160x120')), $photo->getLink(), array('class' => 'avatar')) ?>
    <?php endif ?>
    </div>
  </div>
</div>
<?php endif; ?>
<?php if(stConfig::get('enable_audio')) : ?>
<div id="latest-audios" class="box1 small">
  <div class="inner">
    <h2><?php print __("My latest audio file") ?></h2>
    <div class="content">
    <?php if($audio->isNew()): ?>
      <?php print image_tag("no_audios.png", array('alt' => "Keine Audios vorhanden", 'size' => '160x120')) ?>
    <?php else: ?>
      <?php print link_to(image_tag($audio->getThumbnail(array('size' => '160x120')), array('alt' => $audio->getTitle(), 'size' => '160x120')), $audio->getLink(), array('class' => 'avatar')) ?>
    <?php endif ?>
    </div>
  </div>
</div>
<?php endif; ?>
<?php if(stConfig::get('enable_document')) : ?>
<div id="latest-documents" class="box1 small">
  <div class="inner">
    <h2><?php print __("My latest document") ?></h2>
    <div class="content">
    <?php if($document->isNew()): ?>
      <?php print image_tag("no_documents.png", array('alt' => "Keine Dokumente vorhanden", 'size' => '160x120')) ?>
    <?php else: ?>
      <?php print link_to(image_tag($document->getThumbnail(array('size' => '160x120')), array('alt' => $document->getTitle(), 'size' => '160x120')), $document->getLink(), array('class' => 'avatar')) ?>
    <?php endif ?>
    </div>
  </div>
</div>
<?php endif; ?>
</div>
<?php endif; ?>
