<!-- Version SVN: $Id: _viewGuestbook.php 103 2011-08-11 10:24:44Z sven.poeche $ -->
<div class="box-wm comments">

	<h2><?php print __("@count comments", array("@count" => $comment_pager->getNBResults())); ?></h2>
    
	<div class="content list clearfix">
		<?php if($comment_pager->getNBResults() > 0) : ?>
		<ul class="clearfix">
			<?php foreach($comment_pager->getResults() as $comment) : ?>
			<li class="clearfix">
          <div class="image">             
            <?php $annotator=$comment->getUserRelatedByAnnotatorUid(); ?>
            <?php include_component('user', 'avatar', array('user' => $annotator, 'options' => array('size' => '80x80'))); ?>
      		</div>                
                
                <div>
                    <h3>
                        <?php print $annotator->getLinkTo(); ?>
                        <cite><?php print __('wrote @timediff', array('@timediff' => st_simple_time_ago_in_words($comment->getCreatedAt(null)))); ?></cite>
                    </h3>
                    <p><?php print $comment->getDescription(); ?></p>
                </div>
        	</li>
      		<?php endforeach; ?>
    	</ul>
        
      <?php if($comment_pager->haveToPaginate()) : ?>
      <div class="bottomLink">
      <?php include_component('media', 'pager', array('no_param' => false, 'page_param_name' => 'cpg', 'pager' => $comment_pager, 'link' => $user->getLink(), 'ajaxLink' => "user/ajaxList?user=".$user->getUsername()."&uid=".$user->getUid(), 'id' => 'guestbook_content', 'perPage' => stConfig::get('user_comments_perpage'), 'caption' => __(""), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>
  		<?php else : ?>
   		<p class="empty"><?php print __("No comments available yet."); ?></p>
  		<?php endif ?>
            
	</div>
    
</div>

<?php if($user->canComment()) : ?>
<?php setFormErrors($formNewComment); ?>
<div class="box-wm commentForm">
	<h2><?php print __("Write your comment"); ?></h2>
	<div class="content clearfix">
		<?php echo dojo_form_remote_tag(
            array(
              'update'   => array('success' => 'guestbook_content'),
              'before' => $formNewComment['text']->getWidget()->updateTextareaJS('comment[text]'),
              'success' => array('after' => $formNewComment['text']->getWidget()->reloadEditorJS('comment[text]')),
              #'timeout' => 2000,
              'hasBody' => true,
              'url'      => '/user/saveComment?user='.$user->getUsername(),
              'renderWidgets' => true,
            ),
            array(
              "id" => "antworten",
              "method" => "post",
              "enctype" => "application/x-www-form-urlencoded",
            )
          ); ?>
          
		<div>
            <p>
                <?php //print $formNewComment['text']->renderLabel(); ?>
                <?php print $formNewComment['text']->render(); ?>
            </p>
            <div class="bottomLink">
				<?php print $formNewComment['_csrf_token']->render(); ?>
			<input type="image" id="reply" value="yes" src="/images/frontend/backgrounds/ghost.png" alt="<?php print __('Send comment'); ?>" title="<?php print __('Send comment'); ?>" />
            </div>
		</div>
        
		<?php print '</form>'; ?>
	</div>
</div>
<?php endif; ?>
