<?php

/**
 * This file is part of the ViMP Framework package.
 * (c) ViMP GmbH <info@vimp.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @package     framework
 * @subpackage
 * @author      ViMP GmbH
 * @version     SVN: $Id: _viewBlogs.php 2 2011-06-28 20:23:44Z sven.poeche $
 */
?>
<div class="box2" id="blogs">
  <div class="inner">
    <h2><?php echo __("Blogs") ?></h2>
    <div class="content blog">
      <?php foreach($blog_pager->getResults() as $blog): ?>

      <div class="post clearfix">
        <h3 class="title">
          <?php echo link_to(truncate_text($blog->getTitle(), 24), "blog/show?blogid=".$blog->getBlogid()) ?>
        </h3>

        <?php include_component('user', 'avatar', array('user' => $blog->getUser(), 'options' => array('size' => '48x36'), 'show_overlay' => false)); ?>

        <cite>
          <strong class="author"><?php echo $blog->getUser()->getLinkTo() ?></strong> &middot; <span class="date"><?php echo format_datetime($blog->getCreatedAt(null)) ?></span>
        </cite>

        <?php echo truncate_text($blog->getDescription(), 250) ?>

        <?php if(!is_null($blog->getUpdatedByUser())): ?>
        <span><?php echo __("Last modified by ") ?>
        <strong><?php echo $blog->getUpdatedByUser() ?></strong>
        <span>am</span>
        <span><?php echo format_date($blog->getUpdatedAt(null)) ?></span>
        </span>
        <?php endif ?>
      </div>
      <?php endforeach ?>
      <?php if($blog_pager->haveToPaginate()) : ?>
      <div class="bottomlink">
      <?php include_component('media', 'pager', array('page_param_name' => 'bpg', 'short' => true, 'pager' => $blog_pager, 'link' => $user->getLink(), 'perPage' => stConfig::get('user_blog_perpage'), 'caption' => __("Blogs"), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>

    </div>
  </div>
</div>
