<?php

/**
 * This file is part of the ViMP Framework package.
 * (c) ViMP GmbH <info@vimp.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @package     framework
 * @subpackage
 * @author      ViMP GmbH
 * @version     SVN: $Id: _viewActions.php 2 2011-06-28 20:23:44Z sven.poeche $
 */
?>

<div id="actions" class="box1 small">
  <div class="inner">
      <h2>
        <?php echo __("Actions") ?>
      </h2>
      <div class="content">
      <?php if($user->getUid() == $sf_context->getUser()->getUid()): // View own Profile ?>
      <ul>
      <?php if($user->canEdit()): ?>
        <li>
          <?php echo link_to(__("Edit your profile"), $sf_context->getUser()->getLinkEdit()) ?>
        </li>
        <li>
          <?php echo link_to(__("Change password"), "user/changePassword?id=".$user->getUid()) ?>
        </li>
        <?php endif ?>
        <li>
          <?php echo link_to(__("Upload your medium now!"), "media/upload") ?>
        </li>
<?php if (stToolkit::moduleEnabled('friends') && stConfig::get('enable_friends')) : ?>
        <li>
          <?php echo link_to(__("Manage friends"), "friends/index") ?>
        </li>
<?php endif; ?>
<?php if (stToolkit::moduleEnabled('group') && stConfig::get('enable_groups')) : ?>
        <!--
        <li>
          <?php // echo link_to(__("Gruppen verwalten"), "#") ?>
        </li>
         -->
<?php endif; ?>
<?php if (stToolkit::moduleEnabled('community') && stConfig::get('enable_community')) : ?>
        <li>
          <?php echo link_to(__("Clear history"), "community/deleteHistory", array('post'=> false, 'confirm' => __('Do you really want to clear your history?'))) ?>
        </li>
<?php endif; ?>
        <?php if($user->canDelete()): ?>
        <li>
          <?php echo link_to(__("Delete profile"), "user/delete") ?>
        </li>
      <?php endif ?>
      </ul>
      <?php else: // View other Profile ?>
      <ul>
<?php if (stToolkit::moduleEnabled('pm') && stConfig::get('enable_pm')) : ?>
        <li>
          <?php echo link_to(__("Send me a private message"), "pm/new?username=".$user->getUsername()) ?>
        </li>
<?php endif; ?>
      <?php if(stToolkit::moduleEnabled('friends') && stConfig::get('enable_friends') && $user->canInvite()): ?>
        <li>
          <?php echo link_to(__("Add as a friend"), "friends/invite?id=".$user->getUid()) ?>
        </li>
      <?php endif ?>
        <li>
          <?php echo link_to(__("Upload your medium now!"), "media/upload") ?>
        </li>
      </ul>

      <?php if($sf_user->hasCredential('edit user profile')): // Admin/Moderator ??>
      <h2><?php echo __("Moderator") ?></h2>
      <ul>
        <li>
          <?php echo link_to(__("Edit profile"), $user->getLinkEdit()) ?>
        </li>
        <?php if($sf_user->hasCredential("delete user profile")): ?>
        <li>
          <?php echo link_to(__("Delete profile"), "user/delete?id=".$user->getUid()) ?>
        </li>
      <?php endif ?>
      </ul>
      <?php endif ?>
      <?php endif ?>
    </div>
  </div>
</div>
