<div class="box-s">
	<h2><?php print __("Groups"); ?></h2>
	<div class="content groupslist clearfix">
		<?php if($groups->getNBResults() > 0) : ?>
		<ul class="clearfix">
			<?php foreach($groups->getResults() as $group): ?>
			<li class="clearfix">
        <?php include_component('group', 'picture', array('group' => $group, 'options' => array('size' => '110x73'))); ?>
				<h3 title="<?php print esc_quotes($group->getTitle()); ?>"><?php print link_to(truncate_text($group->getTitle(), 15), $group->getLink(), array('title' => $group->getTitle())); ?></h3>
				<p><?php print __("@count members", array("@count" => $group->countGroupMembers())) ?></p>
			</li>
			<?php endforeach ?>
		</ul>
        
        <div class="bottomLink">
			<?php echo link_to(__('more'), 'user/viewMyGroups?username='.$user->getUsername(), array('class' => 'more')); ?>
        </div>
        
	<?php else : ?>
		<p class="empty"><?php print __('This user is not a member of any group.'); ?></p>
	<?php endif; ?>
	</div>
</div>
