<div id="<?php print $params['container_id']; ?>" class="slider_box_container clearfix">
	<div id="slider_handles" class="panel clearfix">
    <?php foreach($slides as $index => $slide): ?>
		<span><?php print $slide->getTitle(); ?></span>
    <?php endforeach; ?>
	</div>
  <a href="#" id="slideLeftButton" class="button">&laquo;</a>
  <div class="slider_mask clearfix">
    <div id="slider_box" class="slider_box">
      <?php foreach($slides as $index => $slide): ?>
      <div id="slide_<?php print $index; ?>" class="slides clearfix">
        <div class="image">
          <?php echo image_tag($slide->getPictureOrMediaPicture(array('size' => '365x230'))); ?>
          <span>#</span>
        </div>
        <div class="text">
          <h2><?php echo $slide->getTitle(); ?></h2>
          <p><?php echo $slide->getText(); ?></p>
        </div>
        <?php if($slide->hasMedia() && $slide->getMedia()) : ?>
        <div class="bottomLink">
          <?php print link_to(__('more'), $slide->getMedia()->getLink(), array('class' => 'more')); ?>
        </div>
        <?php endif; ?>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
  <a href="#" id="slideRightButton" class="button">&raquo;</a>
</div>
<script type="text/javascript">
	window.addEvent('domready',function(){
		var slider = new noobSlide({
			box: $('slider_box'),
			items: $$('#slider_box h2'),
			size: 660,
			handles: $$('#slider_handles span'),
      fxOptions: { property: 'left', duration: 1000, transition: Fx.Transitions.Back.easeOut, wait:  false},
			addButtons: {previous: $('slideLeftButton'), next: $('slideRightButton') },
      onWalk: function(currentItem, currentHandle){
				$$(this.handles).removeClass('active');
				$$(currentHandle).addClass('active');
			},
      interval: <?php print stConfig::get('slider_interval'); ?>,
      autoPlay: <?php print var_export(stConfig::get('slider_autoplay'), true); ?>
		});
	});
</script>
