<!-- Version SVN: $Id: indexSuccess.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<?php if($search): include_component('search', 'result', array('search' => $search, 'culture' => sfContext::getInstance()->getUser()->getCulture())); endif; ?>

<?php setFormErrors($form); ?>
<div class="box-w">
  <h2><?php print __('Extended search'); ?></h2>
  <div class="content">
      <form method="post" action="<?php print url_for('search/index'); ?>" id="advanced_search" class="clearfix">
        <div class="left">
          <?php print $form["title"]->renderLabel(); ?>
          <?php print $form["title"]->render(); ?>
          <?php print $form["description"]->renderLabel(); ?>
          <?php print $form["description"]->render(); ?>
          <?php print $form["tags"]->renderLabel(); ?>
          <?php print $form["tags"]->render(); ?>
          <?php print $form["type"]->renderLabel(); ?>
          <?php print $form["type"]->render(); ?>
        </div>
        <div class="right">
          <?php if(isset($form["categoriesopt"])) : ?>
          <div class="clearfix" id="catswitch">
            <?php print $form["categoriesopt"]->renderLabel(); ?>
            <?php print $form["categoriesopt"]->render(array('class' => 'radio')); ?>
          </div>
          <?php print $form["categories"]->render(array('outer' => array('class' => 'categories clearfix'), 'class' => 'checkbox')); ?>
          <?php endif; ?>
          <?php if(stConfig::get('enable_groups') && isset($form["groupsopt"])) : ?>
          <div class="clearfix">
            <?php print $form["groupsopt"]->renderLabel(); ?>
            <?php print $form["groupsopt"]->render(array('class' => 'radio')); ?>
          </div>
          <?php print $form["groups"]->render(array('outer' => array('class' => 'groups clearfix'), 'class' => 'checkbox')); ?>
          <?php endif; ?>
          <?php if(stConfig::get('enable_channels') && isset($form["channelsopt"])) : ?>
          <div class="clearfix" id="chaswitch">
            <?php print $form["channelsopt"]->renderLabel(); ?>
            <?php print $form["channelsopt"]->render(array('class' => 'radio')); ?>
          </div>
          <?php print $form["channels"]->render(array('outer' => array('class' => 'channels clearfix'), 'class' => 'checkbox')); ?>
          <?php endif; ?>
          <?php print $form["_csrf_token"]->render(); ?>
        </div>
        <div class="bottomLink">
        	<input id="reply" class="button" type="image" title="<?php print __('Search'); ?>" alt="<?php print __('Search'); ?>" name="search_adv_submit" value="yes" src="/images/frontend/backgrounds/ghost.png" />
        </div>
      </form>
  </div>
</div>

<script type="text/javascript" language="Javascript">
//<![CDATA[
  dojo.addOnLoad(function() {
    initOptions = function(type, defaultId) {
      var input = dojo.byId('search_'+type+'opt_'+defaultId);
      dojo.forEach(dojo.query('input[id^=\"search_'+type+'_\"]'), function(node) {
        node.disabled = (input.value == 1) ? false : true;
      });
      dojo.forEach(dojo.query('.channel_info.'+type), function(node) {
        dojo.style(node, 'display', input.value == 1 ? '' : 'none');
      });
      dojo.forEach(dojo.query('input[id^="search_'+type+'opt_"]'), function(node) {
        dojo.connect(node, 'onclick', function() {
          var input = this;
          dojo.forEach(dojo.query('input[id^=\"search_'+type+'_\"]'), function(node) {
            node.disabled = (input.value == 1) ? false : true;
          });
          dojo.forEach(dojo.query('.channel_info.'+type), function(node) {
            dojo.style(node, 'display', input.value == 1 ? '' : 'none');
          });
        });
      });
    }

<?php if(isset($form["categoriesopt"])) : ?>
    initOptions('categories', <?php print (int) $form["categoriesopt"]->getValue(); ?>);
<?php endif; ?>
<?php if(isset($form["groupsopt"])) : ?>
    initOptions('groups', <?php print (int) $form["groupsopt"]->getValue(); ?>);
<?php endif; ?>
<?php if(isset($form["channelsopt"])) : ?>
    initOptions('channels', <?php print (int) $form["channelsopt"]->getValue(); ?>);
<?php endif; ?>
  });
//]]>
</script>
