<!-- Version SVN: $Id: outboxSuccess.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<h1><?php print __('My profile');?></h1>
<div class="box-w user clearfix">
	<?php include_component("user", "viewUser", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
</div>

<div class="box-w messages clearfix">
  <div class="top clearfix">
    <h2><?php print __('Messages'); ?></h2>
    <?php include_component("pm", "pmMenu", array('culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
  <div class="content message">
  <?php if($outbox_pager->getNBResults() > 0) : ?>
    <form method="post" action="<?php print url_for("pm/deleteReceipt"); ?>"  enctype="application/x-www-form-urlencoded" id="inbox" name="inbox">
      <div>
        <ul class="clearfix">
        <?php foreach($outbox_pager->getResults() as $message) : ?>
          <li class="clearfix<?php print $message->isRead() ? ' read' : ' unread' ?>">
            <ul class="clearfix">
              <li class="icon">
                <?php print link_to($message->getSubject(), $message->getLink()); ?>
              </li>
              <li>
              	<div class="image">
                  <?php include_component('user', 'avatar', array('user' => $message->getUserRelatedByRecipientUid(), 'options' => array('size' => '80x80'))); ?>
                </div>
              </li>
              <li class="title">
                <?php print $message->getUserRelatedByRecipientUid()->getLinkTo(); ?>
                <cite><?php print format_datetime($message->getCreatedAt()); ?></cite>
              </li>
              <li class="subject"><?php print link_to($message->getSubject(), "pm/showOut?id=".$message->getPmoid()); ?></li>
              <li class="del">
                <?php print link_to(__('Delete'), $message->getLinkDelete(), array('title' => __('Delete'), 'confirm' => __('Are you sure you want to delete this message?'))); ?>
              </li>
            </ul>
          </li>
        <?php endforeach; ?>
        </ul>
      <?php if($outbox_pager->haveToPaginate()) : ?>
      <div class="bottomlink">
      <?php include_component('media', 'pager', array('no_param' => true, 'page_param_name' => 'outbpg', 'pager' => $outbox_pager, 'link' => "pm/outbox", 'ajaxLink' => "pm/outbox", 'id' => 'content', 'perPage' => stConfig::get("outbox_perpage"), 'caption' => __(""), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>
      </div>
    </form>
    <?php else : ?>
      <p class="empty"><?php print __('Your outbox is empty.'); ?></p>
    <?php endif; ?>
  </div>
</div>
