<!-- Version SVN: $Id: uploadSuccess.php 890 2012-07-05 17:07:01Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
<?php $validators = $formMediaUpload->getValidatorSchema(); ?>

<h1><?php print __('Upload medium'); ?></h1>

<?php setFormErrors($formMediaUpload); ?>
<div id ="upload" class="box-w content">
  <form method="post" action="<?php print url_for('media/upload'); ?>" enctype="multipart/form-data" id="media_upload" name="media_upload">
    <dl>
			<div id="upload_methods" class="clearfix">
        <input type="hidden" id="upload_method" name="upload_method" value="<?php print $uploadMethod; ?>">
        <a href="#" class="act" onclick="switchUploadMethod(this); return false;">Upload</a>
        <?php if(stToolkit::moduleEnabled('youtubeImport') && stConfig::get('enable_youtube')) : ?>
        <a href="#" onclick="switchUploadMethod(this, 'youtubeimport'); return false;">Youtube-Import</a>
        <?php endif; ?>
        <script type="text/javascript">
          dojo.addOnLoad(function() {
            switchUploadMethod(document.getElementById('upload_methods').getElementsByTagName('a')[<?php print $uploadMethod == 'youtubeimport' ? 1 : 0; ?>], '<?php print $uploadMethod; ?>', false);
          });
        </script>
      </div>

      <div name="upload_container" id="swfupload_container" class="upload_container">
        <dt><label><?php print __('Media'); ?></label></dt>
        <dd>
          <?php include_component('swfupload', 'widget', array('culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
        </dd>
      </div>

      <?php if(stToolkit::moduleEnabled('youtubeImport') && stConfig::get('enable_youtube')) : ?>
      <div name="upload_container" id="youtubeimport_container" class="upload_container">
        <?php include_partial('youtubeImport/form', array('form' => $youtubeImportForm, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>

      <dt><?php print $formMediaUpload["title"]->renderLabel($formMediaUpload["title"]->renderLabelName().($validators["title"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd><?php print $formMediaUpload["title"]->render(); ?></dd>

      <dt><?php print $formMediaUpload["description"]->renderLabel($formMediaUpload["description"]->renderLabelName().($validators["description"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd><?php print $formMediaUpload["description"]->render(); ?></dd>

      <dt><?php print $formMediaUpload["tags"]->renderLabel($formMediaUpload["tags"]->renderLabelName().($validators["tags"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd><?php print $formMediaUpload["tags"]->render(); ?></dd>

      <?php if(stToolkit::moduleEnabled('googlemap') && stConfig::get('google_maps_key') && stConfig::get('google_maps_media')) : ?>
        <?php include_partial('googlemap/form', array('form' => $googleForm, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      <?php endif; ?>

      <dt><?php print $formMediaUpload["categories"]->renderLabel($formMediaUpload["categories"]->renderLabelName().($validators["categories"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd><?php print $formMediaUpload["categories"]->render(array('outer' => array('class' => 'clearfix'), 'class' => 'checkbox')); ?></dd>

<?php /* <-- Payment --> */ ?>
<?php if(stConfig::get('enable_payment') && sfContext::getInstance()->getUser()->hasCredential('payment upload price')): ?>
      <div id="payment_media_properties">
        <dt><?php print $formMediaUpload['with_costs']->renderLabel(); ?></dt>
        <dd><?php print $formMediaUpload['with_costs']->render(); print tag('br'); ?></dd>

        <dt><?php print $formMediaUpload["price"]->renderLabel(); ?></dt>
        <dd><?php print $formMediaUpload["price"]->render(); ?></dd>
      </div>
<?php endif; ?>
<?php /* <-- /Payment --> */ ?>

      <dt><?php echo $formMediaUpload["meta_title"]->renderLabel($formMediaUpload["meta_title"]->renderLabelName().($validators["meta_title"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd class="clearfix"><?php echo $formMediaUpload["meta_title"]->render(); ?></dd>

      <dt><?php echo $formMediaUpload["meta_description"]->renderLabel($formMediaUpload["meta_description"]->renderLabelName().($validators["meta_description"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd class="clearfix"><?php echo $formMediaUpload["meta_description"]->render(); ?></dd>

      <dt><?php echo $formMediaUpload["meta_keywords"]->renderLabel($formMediaUpload["meta_keywords"]->renderLabelName().($validators["meta_keywords"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd class="clearfix"><?php echo $formMediaUpload["meta_keywords"]->render(); ?></dd>

      <dt><?php echo $formMediaUpload["meta_author"]->renderLabel($formMediaUpload["meta_author"]->renderLabelName().($validators["meta_author"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd class="clearfix"><?php echo $formMediaUpload["meta_author"]->render(); ?></dd>

      <dt><?php echo $formMediaUpload["meta_copyright"]->renderLabel($formMediaUpload["meta_copyright"]->renderLabelName().($validators["meta_copyright"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd class="clearfix"><?php echo $formMediaUpload["meta_copyright"]->render(); ?></dd>

      <dt><?php print $formMediaUpload["hidden"]->renderLabel($formMediaUpload["hidden"]->renderLabelName().($validators["hidden"]->getOption('required') ? ' *' : null)); ?></dt>
      <dd><?php print $formMediaUpload["hidden"]->render(array('outer' => array('class' => 'clearfix'), 'class' => 'radio')); ?></dd>

      <?php
        // Include Media Permissions -->
        if ($sf_user->hasCredential('set media permission'))
        {
            include_partial('addMediaPermission',array('formMediaUpload'=>$formMediaUpload));
        }
        // <--
      ?>
      
      <dt>&nbsp;</dt>
      <dd>
        <div class="bottomLink">
          <?php print $formMediaUpload["_csrf_token"]->render(); ?>
          <input type="image" title="<?php print __('Save changes'); ?>" alt="<?php print __('Save changes'); ?>" name="media_edit_submit" id="reply" src="/images/frontend/backgrounds/ghost.png" value="yes" class="button" />
        </div>
      </dd>
		</dl>
	</form>
</div>

<?php //include_component('webcontent', 'hint', array('content' => stConfig::get('webcontent_hint_media_upload'), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
