<!-- Version SVN: $Id: editSuccess.php 890 2012-07-05 17:07:01Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<h1><?php print $media->getCaption($media->getMediatype(), true, true); ?></h1>

<?php setFormErrors($formMediaEdit); ?>
<div class="col-l">
  <div class="box-wm">
    <h2><?php print __('Edit medium'); ?></h2>
    <div id ="edit" class="content edit">
      <form method="post" action="<?php print url_for('media/edit?key='.$media->getMediaKey()); ?>" enctype="multipart/form-data" id="media_edit" name="media_edit">
        <dl>
          <dt><?php echo $formMediaEdit["title"]->renderLabel(); ?></dt>
            <dd><?php echo $formMediaEdit["title"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["description"]->renderLabel(); ?></dt>
            <dd><?php echo $formMediaEdit["description"]->render(); ?></dd>

            <?php if(isset($formMediaEdit["thumbnail"])) : ?>
              <dt><?php echo $formMediaEdit["thumbnail"]->renderLabel(); ?></dt>
              <dd><?php echo $formMediaEdit["thumbnail"]->render(); ?></dd>
            <?php endif; ?>

            <dt><?php echo $formMediaEdit["tags"]->renderLabel(); ?></dt>
            <dd><?php echo $formMediaEdit["tags"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["categories"]->renderLabel(); ?></dt>
            <dd class="clearfix"><?php echo $formMediaEdit["categories"]->render(); ?></dd>

            <?php /* <-- Payment --> */ ?>
            <?php if(stConfig::get('enable_payment') && $media->isPriceable() && sfContext::getInstance()->getUser()->getUser()->hasPermission('payment upload price')): ?>
            <dt><?php print $formMediaEdit['with_costs']->renderLabel(); ?></dt>
            <dd><?php print $formMediaEdit['with_costs']->render(); print tag('br'); ?></dd>

            <dt><?php print $formMediaEdit["price"]->renderLabel(); ?></dt>
            <dd><?php print $formMediaEdit["price"]->render(); ?></dd>
            <?php endif; ?>
            <?php /* <-- /Payment --> */ ?>

            <dt><?php echo $formMediaEdit["meta_title"]->renderLabel(); ?></dt>
            <dd class="clearfix"><?php echo $formMediaEdit["meta_title"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["meta_description"]->renderLabel(); ?></dt>
            <dd class="clearfix"><?php echo $formMediaEdit["meta_description"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["meta_keywords"]->renderLabel(); ?></dt>
            <dd class="clearfix"><?php echo $formMediaEdit["meta_keywords"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["meta_author"]->renderLabel(); ?></dt>
            <dd class="clearfix"><?php echo $formMediaEdit["meta_author"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["meta_copyright"]->renderLabel(); ?></dt>
            <dd class="clearfix"><?php echo $formMediaEdit["meta_copyright"]->render(); ?></dd>

            <dt><?php echo $formMediaEdit["hidden"]->renderLabel(); ?></dt>
            <dd><?php print $formMediaEdit["hidden"]->render(array('outer' => array('class' => 'clearfix'))); ?></dd>

            <?php if(stToolkit::moduleEnabled('googlemap') && stConfig::get('google_maps_key') && stConfig::get('google_maps_media')) : ?>
              <dt>&nbsp;</dt>
              <dd><?php include_partial('googlemap/form', array('form' => $googleForm, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?></dd>
            <?php endif; ?>

            <?php
                // Include Media Permissions -->
                if ($sf_user->hasCredential('set media permission'))
                {
                    include_partial('editMediaPermission',array('formMediaEdit'=>$formMediaEdit));
                }
                // <--
            ?>
            
            <dt>&nbsp;</dt>
            <dd>
              <div class="bottomLink">
              <?php echo $formMediaEdit["_csrf_token"]->render(); ?>
              <input type="image" title="<?php print __('Save changes'); ?>" alt="<?php print __('Save changes'); ?>" name="media_edit_submit" id="reply" src="/images/frontend/backgrounds/ghost.png" value="yes" class="button" />
                </div>            
            </dd>
        </dl>
      </form>
    </div>
  </div>
</div>

<div class="col-r">
  <div class="box-s">
    <?php include_component('webcontent', 'hint', array('content' => stConfig::get('webcontent_hint_media_edit'), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
</div>
