<!-- Version SVN: $Id: manageUsersSuccess.php 12 2011-07-25 20:13:41Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<h1><?php print __('Groups');?></h1>

<?php include_component('group', 'boxGroup', array('group' => $group, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<div id="inviteUsers" class="box-w clearfix">
  <div class="top clearfix">
    <h2><?php print __('Edit members'); ?></h2>
    <ul class="sort1 clearfix do">
    <?php if(stToolkit::moduleEnabled('pm') && stConfig::get('enable_pm') && $group->canInvite()) : ?>
      <li><?php print link_to(__('Invite user'), $group->getLinkInvite(), array('class' => 'action')); ?></li>
    <?php endif; ?>
    </ul>
  </div>
  <div id="group-user-list" class="content userlist clearfix">
  <?php if(count($users)) : ?>
    <ul class="clearfix">
      <?php $last = count($users) - 1; ?>
      <?php foreach($users as  $index => $user) : ?>
      <li class="clearfix<?php print ($index == 0 ? ' first' : NULL).($index == $last ? ' last' : NULL).($index % stConfig::get('media_perrow') == stConfig::get('media_perrow') - 1 ? ' divide' : NULL); ?>">
        <div class="image">
          <?php include_component('user', 'avatar', array('user' => $user, 'options' => array('size' => '80x80'))); ?>
        </div>
        <h3 title="<?php print esc_quotes($user->getUsername()); ?>"><?php print link_to(truncate_text($user->getUsername(), 35), $user->getLink(), array('title' => $user->getUsername())); ?></h3>
        <ul>
          <?php if($group->isMember($user) == -1 && !$group->isInvited($user)) : ?>
          <li><?php print link_to(__('Accept'), 'group/confirmUser?key='.$group->getGroupkey().'&uid='.$user->getUid()); ?></li>
          <?php  endif; ?>
          <?php if($group->isMember($user) == -2 && $group->isInvited($user)) : ?>
          <li><?php print __('invited'); ?></li>
          <?php  endif; ?>
          <?php if($group->isMember($user) == 0) : ?>
          <li><?php print __('illegal'); ?></li>
          <?php  endif; ?>
          <?php if($group->isMember($user) == 1) : ?>
          <li><?php print __('Member'); ?></li>
          <?php  endif; ?>
          <li><?php print link_to(__('Delete'), 'group/deleteUser?key='.$group->getGroupkey().'&uid='.$user->getUid(), array('method' => 'post', 'confirm' => __('Are you sure?'))); ?></li>
        </ul>
      </li>
      <?php endforeach; ?>
    </ul>
  <?php else : ?>
    <p class="empty">
      <?php print __('No users found matching the criteria.'); ?>
    </p>
  <?php endif; ?>
  </div>
</div>
