<!-- Version SVN: $Id: manageMediasSuccess.php 12 2011-07-25 20:13:41Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<h1><?php print __('Groups');?></h1>

<?php include_component('group', 'boxGroup', array('group' => $group, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<div class="box-w clearfix">
	<div class="top clearfix">
    	<h2><?php echo __('Manage media', array('@group' => link_to($group->getTitle(), $group->getLink()))); ?></h2>
  	</div>
  	<div id="group-media-list" class="content thumbs clearfix">
  	<?php if(count($medias)) : ?>
   		<ul class="clearfix">
      	<?php $last = count($medias) - 1; ?>
      	<?php foreach($medias as  $index => $media) : ?>
      		<li class="clearfix<?php print ($index == 0 ? ' first' : NULL).($index == $last ? ' last' : NULL).($index % stConfig::get('media_perrow') == stConfig::get('media_perrow') - 1 ? ' divide' : NULL); ?>">        
 				<div>
          <?php include_component('media', 'thumbnail', array('media' => $media, 'options' => array('size' => '135x76'), 'simple' => true, 'show_info' => false, 'show_title' => false)); ?>
				</div>      
       
        		<h3 title="<?php print esc_quotes($media->getTitle()); ?>"><?php print link_to(truncate_text($media->getTitle(), 35), $media->getLink(), array('title' => $media->getTitle())); ?></h3> 
        
        		<?php echo __('from %user%', array('%user%' => link_to($media->getUser()->getUsername(), $media->getUser()->getLink()))); ?>
        		<ul>
          			<?php if(!$media->hasGroup($group)) : ?>
          			<li><?php print link_to(__('Assign'), 'group/addMedia?key='.$group->getGroupkey().'&mid='.$media->getMid()); ?></li>
          			<?php  else : ?>
          			<li><?php print link_to(__('Delete'), 'group/deleteMedia?key='.$group->getGroupkey().'&mid='.$media->getMid(), array('method' => 'post', 'confirm' => __('Are you sure?'))); ?></li>
					<?php  endif; ?>
        		</ul>
      		</li>
      		<?php endforeach; ?>
    	</ul>
 		<?php else : ?>
    	<p class="empty">
      		<?php print __('No matching medium found.'); ?>
    	</p>
 		<?php endif; ?>
  	</div>
</div>
