<!-- Version SVN: $Id: _boxGroup.php 840 2012-06-27 22:40:02Z sven.poeche $ -->
<div class="box-w groups clearfix">
  
	<div class="content profile clearfix">

        <div class="group avi">
          <?php include_component('group', 'picture', array('group' => $group, 'options' => array('size' => '247x180'), 'linked' => false)); ?>
        </div>
        <div id="info" class="groupInfo"> 
            <h2 class="title clearfix">
				<span><?php print __('@group', array('@group' => $group->getTitle())); ?></span>
                <?php if ($group->isHidden()) : ?>
					<span class="state hidden"><?php print __('@state group', array('@state' => $group->isHidden() ? __('private') : __('public'))); ?></span>
                <?php else : ?>
                	<span class="state"><?php print __('@state group', array('@state' => $group->isHidden() ? __('private') : __('public'))); ?></span>
                <?php endif; ?>
            </h2>
            
            <ul>                
                <?php if (!$group->isHidden() || $group->isMember() > 0 || $group->isOwner()) : ?>
                	<li><?php print __('from: @user', array('@user' => link_to(truncate_text($group->getUser()->getName(), 30), $group->getUser()->getLink(), array('title' => $group->getUser()->getName())))); ?></li>
                    <li><?php print __('Created at @date', array('@date' => format_date($group->getCreatedAt(null), 'D'))) ?></li>
                    <li><?php print __("@count members", array("@count" => $group->countGroupMembers() + 1)) ?></li>
                <?php else : ?>
                <li class="empty"><?php print __('No media assigned yet.'); ?></li>
                <?php endif; ?>
            </ul>
        </div> 
  
    
        <ul class="actions">
            <?php if(!$group->isOwner() && $sf_user->isAuthenticated() && !$group->isMember() && !$group->isHidden()) : ?>
                <li><?php print link_to(__('Join this group'), $group->getLinkMembership(), array('class' => 'join')); ?></li>
            <?php endif; ?>
            <?php if(!$group->isOwner() && $sf_user->isAuthenticated() && $group->isMember()) : ?>
                <li><?php print link_to(__('Leave this group'), $group->getLinkMembership(), array('class' => 'leave')); ?></li>
            <?php endif; ?>
            <?php if($group->canDelete()) : ?>
                <li><?php print link_to(__('Delete'), $group->getLinkDelete(), array('class' => 'delete'), array('method' => 'post', 'confirm' => __('Are you sure?'))); ?></li>
            <?php endif; ?>
            <?php if($group->canEdit()) : ?>
                <li><?php print link_to(__('Edit'), $group->getLinkEdit(), array('class' => 'edit')); ?></li>
            <?php endif; ?>
            <?php if($group->canManageMedia()) : ?>
                <li><?php echo link_to(__('Manage media'),  $group->getLinkManageMedia(), array('class' => 'editMedia')) ?></li>
            <?php endif ?>
            <?php if($group->canManageUser()) : ?>
                <li><?php echo link_to(__('Manage users'),  $group->getLinkManageUser(), array('class' => 'editMembers')) ?></li>
            <?php endif ?>
            <?php if($group->canWriteGroupMessage()) : ?>
                <li><?php print link_to(__('Group message'), $group->getLinkGroupMessage(), array('class' => 'groupMessage')); ?></li>
            <?php endif; ?>
            <?php if($group->canInvite()) : ?>
                <li><?php print link_to(__('Invite user'), $group->getLinkInvite(), array('class' => 'invite')); ?></li>
            <?php endif; ?>
            <?php if(stToolkit::moduleEnabled('forum') && stConfig::get('enable_forum') && $group->isOwner() && !$group->hasForum()) : ?>
                <li><?php print link_to(__('Create new forum'), $group->getLinkCreateForum()); ?></li>
            <?php endif; ?>
            <?php if(stToolkit::moduleEnabled('forum') && stConfig::get('enable_forum') && $group->hasForum() && (!$group->isHidden() || $group->isMember() > 0 || $group->isOwner())) : ?>
              <li class="break"><?php print link_to(__('Forum'), $group->getLinkForum(), array('class' => 'forum')); ?></li>
            <?php endif; ?>
        </ul>
    
 	</div> 
    
    <?php if($sf_context->getModuleName().'/'.$sf_context->getActionName() != 'group/view'): ?>
		<?php echo link_to(__('back to profile'), 'group/view?key='.$group->getGroupkey(), array('class' => 'back')); ?>
	<?php endif; ?>
      
</div>
