<!-- Version SVN: $Id: indexSuccess.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<?php if($user->isMyself()) : ?>
	<h1><?php print __('My profile');?></h1>
<?php else : ?>
	<h1><?php print __('Profile of @user', array('@user'=>$user->getUsername()));?></h1>
<?php endif; ?>

<div class="box-w user clearfix">
	<?php include_component("user", "viewUser", array("user" => $user, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
</div>



<?php if(stToolkit::moduleEnabled('friends') && stConfig::get('enable_friends')) : ?>
<div id="my_friends_content" class="box-w clearfix">
	<?php include_component("friends", "myFriends", array(
            "user" => $user,
            'thumbsize' => '80x80',
            'show_delete' => $user->isMyself(),
            'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
</div>
<?php endif; ?>

<?php if($user->isMyself()) : ?>

  <div id="requests" class="box-w">
	<h2><?php print __("Requests awaiting approval"); ?></h2>
  	<?php if($receivedInvitations) : ?>
  	<div class="content userlist">
    	<ul class="clearfix">
    		<?php $c = 0; $cmax = count($receivedInvitations) - 1; foreach($receivedInvitations as $invitation) : ?>
      		<li class="clearfix<?php print ($c == 0 ? ' first' : NULL).($c == $cmax ? ' last' : NULL).($c % 5 == 5 - 1 ? ' divide' : NULL); ?>">
      
      			<div class="image">
              <?php include_component('user', 'avatar', array('user' => $invitation->getUserRelatedByUid(), 'options' => array('size' => '80x80'), 'show_overlay' => false)); ?>
       			</div>
        
        		<h3><?php print $invitation->getUserRelatedByUid()->getLinkTo(null); ?></h3>
        		<cite><?php print format_datetime($invitation->getCreatedAt(null), 'd'); ?></cite>
        		<ul class="clearfix">
<?php if (stToolkit::moduleEnabled('pm') && stConfig::get('enable_pm')) : ?>
                    <li><?php print link_to(__("Send a PM"), "pm/new?username=".$invitation->getUserRelatedByUid()->getUsername()); ?></li>
<?php endif; ?>
                  	<!--Akzeptieren-->
                  	<?php if($sf_user->hasCredential("accept invitation")): ?>
                  	<li><?php print link_to(__("Accept"), "friends/accept?fid=".$invitation->getFid()); ?></li>
                  	<?php endif ?>
                  	<!--Ablehnen-->
                  	<?php if($sf_user->hasCredential("delete invitation")): ?>
                  	<li><?php print link_to(__("Reject"), "friends/deny?fid=".$invitation->getFid(), array('post' => false, 'confirm' => __('Are you sure?'))); ?></li>
                  	<?php endif ?>
        		</ul>
      		</li>
      		<?php $c++; ?>
    		<?php endforeach; ?>
    	</ul>
	</div>
  	<?php else : ?>
  	<div class="content">
    	<p class="empty"><?php print __("There are no pending friend requests!"); ?></p>
  	</div>
  	<?php endif; ?>
</div>

<div id="pending" class="box-w">
	<h2><?php print __("Pending friend requests"); ?></h2>
  	<div class="content userlist">
  		<?php if($requestedInvitations) : ?>
    	<ul class="clearfix">
    		<?php $c = 0; $cmax = count($requestedInvitations) - 1; foreach($requestedInvitations as $invitation) : ?>
      		<li class="clearfix<?php print ($c == 0 ? ' first' : NULL).($c == $cmax ? ' last' : NULL).($c % 5 == 5 - 1 ? ' divide' : NULL); ?>">
                <div class="image">
                <?php include_component('user', 'avatar', array('user' => $invitation->getUserRelatedByFriendUid(), 'options' => array('size' => '80x80'))); ?>
                </div>
                <h3><?php print $invitation->getUserRelatedByFriendUid()->getLinkTo(null); ?></h3>
                <cite><?php print format_datetime($invitation->getCreatedAt(null), 'd'); ?></cite>
                <ul class="clearfix">
<?php if (stToolkit::moduleEnabled('pm') && stConfig::get('enable_pm')) : ?>
                    <li><?php print link_to(__("Send a PM"), "pm/new?username=".$invitation->getUserRelatedByFriendUid()->getUsername()); ?></li>
<?php endif; ?>
                    <?php if($sf_user->hasCredential("delete invitation")) : ?>
                    <li><?php print link_to(__("Delete"), "friends/deleteInvitation?fid=".$invitation->getFid(), array('post' => false, 'confirm' => __('Are you sure?'))); ?></li>
                    <?php endif; ?>
                </ul>
      		</li>
			<?php $c++; ?>
    		<?php endforeach; ?>
    	</ul>
  		<?php else : ?>
    		<p class="empty"><?php print __("There are no friend requests at the moment!"); ?></p>
  		<?php endif; ?>
	</div>
</div>
<?php endif; ?>