<h2><?php print __("Guestbook entries of my friends") ?></h2>
<div class="content list clearfix">
<?php if($comments_pager->getNBResults() > 0) : ?>
  <ul>
  <?php foreach($comments_pager->getResults() as $comment) : ?>
    <li>
      <?php include_component('user', 'avatar', array('user' => $comment->getUserRelatedByAnnotatorUid(), 'options' => array('size' => '48x36'), 'show_overlay' => false)); ?>
      <h3>
        <?php print $comment->getUserRelatedByAnnotatorUid()->getLinkTo(); ?>
        <cite><?php print __('at @user', array('@user' => $comment->getUserRelatedByUid()->getLinkTo())); ?></cite>
      </h3>
      <p><?php print $comment->getDescription(); ?></p>
    </li>
  <?php endforeach; ?>
  </ul>
  <?php if($comments_pager->haveToPaginate()) : ?>
  <div class="bottomlink">
  <?php include_component('media', 'pager', array('no_param' => true, 'page_param_name' => 'ncfpg', 'pager' => $comments_pager, 'link' => "community/index", 'ajaxLink' => "community/ajaxList", 'id' => 'friend_comments_content', 'perPage' => stConfig::get("community_max_comments_friends"), 'caption' => __(""), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
  <?php endif; ?>
<?php else: ?>
  <p class="empty"><?php print __('There are no comments available.'); ?></p>
<?php endif; ?>
</div>
