<!-- Version SVN: $Id: _newComments.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<div id="community_lastcomments" class="box2">
  <div class="inner">
    <h2><?php echo __("New comments") ?></h2>
    <div class="content">
      <ul class="comments">
<?php foreach($comments_pager->getResults() as $c): ?>
        <li>
          <?php include_component('user', 'avatar', array('user' => $c->getUser(), 'options' => array('size' => '48x36'), 'show_overlay' => false)); ?>
          <div class="clearfix">
            <cite><strong><?php echo $c->getuser()->getLinkTo(null, array("class" => "autor")) ?></strong> &middot; <span class="date"><?php echo st_simple_time_ago_in_words($c->getCreatedAt(null)) ?></span></cite>
            <h3 class="topic"><?php echo link_to(truncate_text($c->getDescription(), 20), "media/view?key=".$c->getMedia()->getMediaKey(), array("class" => "topic")) ?></h3>
            <?php echo truncate_text($c->getDescription(), 200) ?>
            <?php echo link_to(__("read more"), "media/view?key=".$c->getMedia()->getMediaKey(), array("class"=>"permalink", "title"=>__("Read this comment"))) ?>
          </div>
        </li>
<?php endforeach ?>
      </ul>
      <?php if($comments_pager->haveToPaginate()) : ?>
      <div class="bottomlink">
      <?php include_component('media', 'pager', array('short' => 'true', 'no_param' => true, 'page_param_name' => 'ncpg', 'pager' => $comments_pager, 'link' => "community/index", 'perPage' => stConfig::get("community_max_comments"), 'caption' => __(""), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
