<!-- Version SVN: $Id: _newBlogPosts.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<h2><?php print __("Latest blog entries") ?></h2>
<div class="content list clearfix">
  <?php if($new_blogs_pager->getNBResults() > 0) : ?>
  <ul>
  <?php foreach($new_blogs_pager->getResults() as $blog) : ?>
    <li>
     
      <h3><?php print link_to($blog->getTitle(), "blog/show?blogid=".$blog->getBlogid()); ?></h3>  
          
      <p>
        <?php print $blog->getUser()->getLinkTo() ?>
        <cite><?php print __('wrote @timediff', array('@timediff' => st_simple_time_ago_in_words($blog->getCreatedAt(null)))); ?></cite>
      </p>
      
      <?php echo truncate_text($blog->getDescription(), 140) ?>
      
      <?php print link_to(__("read more"), $blog->getLink(), array('class' => 'readmore')); ?>

    </li>
    <?php endforeach; ?>
  </ul>
  <?php if($new_blogs_pager->haveToPaginate()) : ?>
  <div class="bottomlink">
<?php include_component('media', 'pager', array('no_param' => true, 'page_param_name' => 'nbpg', 'pager' => $new_blogs_pager, 'link' => "community/index", 'ajaxLink' => "community/ajaxList", 'id' => 'new_blogs_content', 'perPage' => stConfig::get("community_blogpost_perpage"), 'caption' => __(""), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>
<?php else : ?>
  <p class="empty"><?php print __("There are no blog entries available."); ?></p>
<?php endif; ?>
</div>
