<!-- Version SVN: $Id: _guestbook.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<h2><?php print __("Latest guestbook entries"); ?></h2>
<div class="content list clearfix">
<?php if($guestbook_pager->getNBResults() > 0) : ?>
  <ul>
  <?php foreach($guestbook_pager->getResults() as $comment) : ?>
      <li>
        <?php include_component('user', 'avatar', array('user' => $comment->getUserRelatedByAnnotatorUid(), 'options' => array('size' => '48x36'), 'show_overlay' => false)); ?>
        <h3><?php print $comment->getUserRelatedByAnnotatorUid()->getLinkTo(); ?> <cite><?php print __('at @user', array('@User' => $comment->getUserRelatedByUid()->getLinkTo())); ?></cite></h3>
      	<p><?php print truncate_text(strip_tags($comment->getDescription()), 70); ?></p>
      </li>
  <?php endforeach; ?>
  </ul>
  <?php if($guestbook_pager->haveToPaginate()) : ?>
  <div class="bottomlink">
  <?php include_component('media', 'pager', array('no_param' => true, 'page_param_name' => 'ncpg', 'pager' => $guestbook_pager, 'link' => "community/index", 'ajaxLink' => "community/ajaxList", 'id' => 'new_guestbook_content', 'perPage' => stConfig::get("community_max_guestbook"), 'caption' => __(""), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
  <?php endif; ?>
<?php else : ?>
  <p class="empty">
    <?php print __('There are no comments available.'); ?>
  </p>
<?php endif; ?>
</div>
