<!-- Version SVN: $Id: _activeUser.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<div class="box1 medium" id="community_mostactiveuser">
  <div class="inner">
    <h2 class="box clearfix">
      <span><?php print __("Most active user:") ?></span>
      <?php print $user->getLinkTo() ?>
    </h2>
    <div class="content clearfix">
        <div class="user">
            <div class="m_info">
                <?php include_component('user', 'avatar', array('user' => $user, 'options' => array('size' => '48x36'))); ?>
                <ul class="about">
                    <li><?php print __('Visits: @count', array('@count' => $user->getCountViews())) ?></li>
                    <li>
                    <?php if(is_null($user->getLastLoginAt(null))): ?>
                      <?php print __('I have not logged in yet') ?>
                    <?php else: ?>
                      <?php print __('Last visit: @timediff', array('@timediff' => st_simple_time_ago_in_words($user->getLastLoginAt(null)))); ?>
                    <?php endif ?>
                    </li>
                    <li><?php print __('Registered: @timediff', array('@timediff' => st_simple_time_ago_in_words($user->getCreatedAt(null)))); ?></li>
                </ul>
            </div>

            <ul class="m_stats">
                <li><?php print image_tag("icon_videos.png", array("alt" => __("Videos"), "title" => __("Videos"))) ?>
                <?php if($user->canLink()): ?>
                  <?php print link_to($user->getCountOwnMediaVideos(), "media/list?type=video&user=".$user->getUsername(), array("title" => __("Videos"))) ?>
                <?php else: ?>
                  <?php print $user->getCountOwnMediaVideos() ?>
                <?php endif ?>
                  <?php print __('My videos have been viewed @count times.', array('@count' => $count_video)) ?>
                </li>
                <li>
                <?php print image_tag("icon_audios.png", array("alt" => __("Audios"), "title" => __("Audios"))) ?>
                <?php if($user->canLink()): ?>
                  <?php print link_to($user->getCountOwnMediaAudios(), "media/list?type=audio&user=".$user->getUsername(), array("title" => __("Audios"))) ?>
                <?php else: ?>
                  <?php print $user->getCountOwnMediaAudios() ?>
                <?php endif ?>
                  <?php print __('My audio files have been listened to @count times.', array('@count' => $count_audio)) ?>
                </li>
                <li>
                <?php print image_tag("icon_photos.png", array("alt" => __("Pictures"), "title" => __("Pictures"))) ?>
                <?php if($user->canLink()): ?>
                  <?php print link_to($user->getCountOwnMediaPhotos(), "media/list?type=photo&user=".$user->getUsername(), array("title" => __("Pictures"))) ?>
                <?php else: ?>
                  <?php print $user->getCountOwnMediaPhotos() ?>
                <?php endif ?>
                  <?php print __('My pictures have been viewed @count times.', array('@count' => $count_photo)) ?>
                </li>
                <li>
                <?php print image_tag("icon_documents.png", array("alt" => __("Documents"), "title" => __("Documents"))) ?>
                <?php if($user->canLink()): ?>
                  <?php print link_to($user->getCountOwnMediaDocuments(), "media/list?type=".Media::TYPE_DOCUMENT, array("title" => __("Documents"))) ?>
                <?php else: ?>
                  <?php print $user->getCountOwnMediaDocuments() ?>
                <?php endif ?>
                  <?php print __('My documents have been read @count times.', array('@count' => $count_document)) ?>
                </li>
                <li><?php print image_tag("icon_youtube.png", array("alt" => __("Youtube"), "title" => __("Youtube"))) ?>
                <?php if($user->canLink()): ?>
                  <?php print link_to($user->getCountOwnMediaYoutube(), "media/list?type=youtube&user=".$user->getUsername(), array("title" => __("Youtube"))) ?>
                <?php else: ?>
                  <?php print $user->getCountOwnMediaYoutube() ?>
                <?php endif ?>
                  <?php print __('My videos have been viewed @count times.', array('@count' => $count_youtube)) ?>
                </li>
            </ul>
        </div>
        <div class="mediafiles clearfix">
          <?php if($user->canLink()): ?>
          <?php print link_to(image_tag($media->getThumbnail(array('size' => '130x98')), array('alt' => $media->getTitle())), $media->getLink(), array('class' => 'avatar')) ?>
          <?php else: ?>
          <?php print image_tag($media->getThumbnail(array('size' => '130x98')), array('alt' => $media->getTitle()), array('class' => 'avatar')) ?>
          <?php endif ?>
          <strong><?php if($user->canLink()): ?>
            <?php print link_to($media->getTitle(), $media->getLink()) ?>
          <?php else: ?>
            <span><?php print $media->getTitle() ?></span>
          <?php endif ?></strong><br />
          <strong><?php print __("Added:") ?></strong> <?php print format_date($media->getCreatedAt(null)) ?><br />
          <strong><?php print __("Hits:") ?></strong> <?php print $media->getCountViews() ?>
        </div>
    </div>
  </div>
</div>
