<!-- Version SVN: $Id: showSuccess.php 890 2012-07-05 17:07:01Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<h1><?php print __('Blogs');?></h1>

<?php /* <-- Workflow --> */ ?>
<?php if(stToolkit::moduleEnabled('workflowFrontend') && stConfig::get('approve_new_blog_contributions') && $blog->getStatus() == Blog::STATUS_VERIFY): ?>
<?php include_component('workflowFrontend', 'blogApproval', array('blog' => $blog)); ?>
<?php endif; ?>
<?php /* <-- /Workflow --> */ ?>

<div class="box-w blog clearfix">
	<div class="top">
    	<?php if (($sf_user->hasCredential('edit blog') || ($sf_user->getUid() == $blog->getUid() && $sf_user->hasCredential('edit own blog'))) ||
              ($sf_user->hasCredential('delete blog') || ($sf_user->getUid() == $blog->getUid() && $sf_user->hasCredential('delete own blog')))) : ?>
    	<div>
    		<ul class="actions clearfix">
      			<?php if($sf_user->hasCredential('edit blog') || ($sf_user->getUid() == $blog->getUid() && $sf_user->hasCredential('edit own blog'))) : ?>
      			<li><?php print link_to(__('Edit'), "blog/edit?blogid=".$blog->getBlogid(), array('class' => 'edit')); ?></li>
      			<?php endif; ?>
      			<?php if($sf_user->hasCredential('delete blog') || ($sf_user->getUid() == $blog->getUid() && $sf_user->hasCredential('delete own blog'))) : ?>
      			<li><?php print link_to(__('Delete'), "blog/delete?blogid=".$blog->getBlogid(), array('class' => 'delete'), array('method' => 'post', 'confirm' => __('Are you sure?'))); ?></li>
      			<?php endif; ?>
    		</ul>
    	</div>
		<?php endif; ?>  
    	<h2 class="title"><?php print $blog->getTitle(); ?></h2>
	</div>    

	<div class="infoLine">
		<?php echo __('by'); ?> <?php echo $blog->getUser()->getLinkTo(null, array("class" => "autor")) ?> - <?php echo format_date($blog->getCreatedAt(), 'p'); ?> - <span class="comments"><?php print $blog->countBlogComments(); ?></span>
	</div>
    
  	<div class="content blog">
    	<p><?php print $blog->getDescription(); ?></p>
	</div>
</div>

<div class="col-l">
  <div class="box-wm comments">
    <h2><?php print __("@Anz comments", array("@Anz" => $comment_pager->getNBResults())); ?></h2>
    <div class="content list clearfix">
    <?php if($comment_pager->getNbResults()) : ?>
      <ul class="clearfix">
      <?php foreach($comment_pager->getResults() as $comment) : ?>
        <li class="clearfix">
          <div class="image"> 
            <?php include_component('user', 'avatar', array('user' => $comment->getUser(), 'options' => array('size' => '80x80'))); ?>
          </div>
          <div>
            <h3>
              <?php print $comment->getUser()->getLinkTo(); ?>
              <cite><?php print __('wrote @timediff', array('@timediff' => st_simple_time_ago_in_words($comment->getCreatedAt(null)))); ?></cite>
            </h3>
            <p><?php print $comment->getDescription(); ?></p>
          </div>
        </li>
      <?php endforeach; ?>
      </ul>
      <?php if($comment_pager->haveToPaginate()) : ?>
      <div class="bottomlink">
      <?php include_component('media', 'pager', array('no_param' => true, 'page_param_name' => 'cpg', 'pager' => $comment_pager, 'link' => "blog/index", 'perPage' => stConfig::get('blog_comments_perpage'), 'caption' => "Comments", 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>
    <?php else : ?>
      <p class="empty"><?php print __('No comments yet.'); ?></p>
    <?php endif; ?>
    </div>
  </div>

<?php if($sf_user->isAuthenticated()) : ?>
<?php setFormErrors($form_comment); ?>
 <div class="box-wm comment">
  <h2><?php print __("Write your comment"); ?></h2>
  <div class="content clearfix">
    <form id="antworten" name="frm_comment" method="post" action="<?php print url_for("blog/updateComment?sort=".$sort); ?>">
      <?php print $form_comment['blogid']->render(); ?>
      <?php print $form_comment['pid']->render(); ?>
      <?php print $form_comment['sid']->render(); ?>
      <?php print $form_comment['uid']->render(); ?>
      <?php print $form_comment['content']->render(); ?>
      <?php print $form_comment['_csrf_token']->render(); ?>
      <div class="bottomLink">
      	<input type="image" title="<?php print __('Reply'); ?>" alt="<?php print __('Reply'); ?>" name="send" id="reply" class="button" value="<?php print __('Send'); ?>" src="/images/frontend/backgrounds/ghost.png" />
      </div>
    </form>
  </div>
 </div>
<?php endif; ?>

</div>
<div class="col-r">
	<div id="more_blogs_container" class="box-s">
  		<?php include_component("blog", "newBlogs", array(
                    'container_id'   => 'more_blogs_container',
                    'for_object'     => 'User',
                    'object_id'      => $blog->getUid(),
                    'user'           => false,
                    'caption'        => __('more'),
                    'truncate_title' => 25,
                    'truncate_descr' => 60,
                    'show_all_link'  => 'user/viewMyBlogs?username='.$blog->getUser()->getUsername(),
                    'show_more_link' => true,
                    'show_pager'     => false,
                    'show_info_line' => false,
                    'show_user_info' => false,
                    'show_filter'    => false,
                    'show_new_blog_post_link' => false,
                    'items_perpage'  => stConfig::get('blog_box_perpage'),
                    'culture'        => $sf_user->getCulture())); ?>
	</div>
</div>