<!-- Version SVN: $Id: editCommentSuccess.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<?php include_component('start', 'breadcrumb', array('breadcrumb' => $breadcrumb, 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>

<h1><?php print __('Blogs');?></h1>

  <div class="box2">
    <div class="inner">
      <h2><?php echo link_to($blog->getTitle(), "blog/show?sort=".$sort."&blogid=".$blog->getBlogid(), array("class" => "title")) ?></h2>
      <div class="content blog">
        <?php echo $blog->getUser()->getLinkTo(image_tag($blog->getUser()->getAvatar(array('size' => '48x36')), array("alt" => $blog->getUser()->getUsername())), array('class' => 'avatar')); ?>
        <cite>
          <strong class="author"><?php echo $blog->getUser()->getLinkTo(null, array("class" => "autor")) ?></strong>
          <span class="date"><?php echo format_datetime($blog->getCreatedAt(null)) ?></span>
        </cite>
        <p><?php echo $blog->getDescription() ?></p>

<?php if(isset($comment_to)): ?>
        <ul class="comments"> <!-- !!ANPASSEN!! -->
          <li class="ft">
            <h3>
              <span class="blog_user">
                <span class="avatar">
                  <?php echo link_to(image_tag($comment_to->getUser()->getAvatar(array('size' => '48x36')), array("alt" => $comment_to->getUser()->getUsername())),  $comment_to->getUser()->getLink()) ?>
                </span>
                <?php echo link_to($comment_to->getUser()->getUsername(), "user/view?id=".$comment_to->getUid(), array("class" => "autor")) ?>
              </span>
            </h3>
            <span class="date">Erstellt: <?php echo format_datetime($comment_to->getCreatedAt()) ?></span>
            <span class="date">Letzte Änderung: <?php echo format_datetime($comment_to->getUpdatedAt()) ?></span>
            <div><?php echo $comment_to->getDescription() ?><br /></div>
          </li>
        </ul>
<?php endif ?>

        <?php setFormErrors($form_comment); ?>
        <form name="frm_comment" method="post" action="<?php echo url_for("blog/updateComment?sort=".$sort) ?>">
          <?php echo $form_comment ?>
          <input type="image" title="<?php print __('Add'); ?>" alt="<?php print __('Add'); ?>" name="blog_comment_submit" id="reply" src="/images/frontend/backgrounds/ghost.png" value="yes" class="button" />
        </form>
      </div>
    </div>
  </div>

<div class="box2">
  <div class="inner">
      <?php include_component('webcontent', 'hint', array('content' => stConfig::get('webcontent_hint_blog_comment'), 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
  </div>
</div>
