<!-- Version SVN: $Id: _newComments.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
<div class="box2">
  <div class="inner">
    <h2><?php echo __("New comments") ?></h2>
    <div class="content blog">
      <?php if($new_comments_pager->haveToPaginate()) : ?>
      <div class="bottomlink">
      <?php include_component('media', 'pager', array('page_param_name' => "ncpg", 'pager' => $new_comments_pager, 'link' => "blog/index?sort=".$sort."&id=".$id, 'perPage' => stConfig::get('blog_new_comments_perpage'), 'caption' => "Blogs", 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
      </div>
      <?php endif; ?>
      <?php foreach($new_comments_pager->getResults() as $comment): ?>
      <div class="post clearfix">

        <h3 class="title">
          <?php echo link_to(truncate_text($comment->getBlog()->getTitle(), 24), "blog/show?sort=".$sort."&blogid=".$comment->getBlogid()."&id=".$id) ?>
        </h3>

        <?php include_component('user', 'avatar', array('user' => $comment->getUser(), 'options' => array('size' => '46x36'), 'show_overlay' => false)); ?>

        <cite>
          <strong class="author"><?php echo $comment->getUser()->getLinkTo(null, array("class" => "autor")) ?></strong> &middot; <span class="date"><?php echo format_datetime($comment->getCreatedAt(null)) ?></span>
        </cite>

        <?php echo truncate_text($comment->getDescription(), 240) ?>
        <?php echo link_to(__('read more'), "blog/show?sort=".$sort."&blogid=".$comment->getBlogid()."&id=".$id, array('class' => 'readmore')) ?>
      </div>
      <?php endforeach ?>
    </div>
  </div>
</div>
