<!-- Version SVN: $Id: _newBlogs.php 2 2011-06-28 20:23:44Z sven.poeche $ -->
  <div class="inner">
    <?php if($params['caption']): ?>
      <h2><?php echo $params['caption']; ?></h2>
    <?php endif; ?>
    <div class="top">
		<?php if($params['show_new_blog_post_link'] AND $sf_context->getUser()->isAuthenticated()) : ?>
            <?php print link_to(__("Post a blog entry"), "blog/new", array('class' => 'action')); ?></li>
        <?php endif; ?>
        <?php if($params['show_filter']): ?>
        <div class="filter clearfix">
          <span><?php echo __('Filter:'); ?></span> 
          <ul class="sort1 clearfix">
              <li<?php print $params['filter'] == 'all'         ? ' class="act"' : NULL; ?>><?php echo dojo_link_to_remote(__('All'),                        array('url' => $ajaxLink.'&filter=all',         'update' => $params['container_id']), array('href' => $module.'/'.$action.'?filter=all')); ?></li>
              <li<?php print $params['filter'] == 'mine'        ? ' class="act"' : NULL; ?>><?php echo dojo_link_to_remote(__('Mine'),                       array('url' => $ajaxLink.'&filter=mine',        'update' => $params['container_id']), array('href' => $module.'/'.$action.'?filter=mine')); ?></li>
              <li<?php print $params['filter'] == 'friends'     ? ' class="act"' : NULL; ?>><?php echo dojo_link_to_remote(__('My friends\' blog entries'), array('url' => $ajaxLink.'&filter=friends',     'update' => $params['container_id']), array('href' => $module.'/'.$action.'?filter=friends')); ?></li>
          </ul>
        </div>
        <?php endif; ?>
    </div>

    <div class="content blog">
      <?php if($new_blogs_pager->getNbResults()>0): ?>
        <?php foreach($new_blogs_pager->getResults() as $blog): ?>
        <div class="post clearfix">
          <h3 class="title"><?php echo link_to(truncate_text($blog->getTitle(), $params['truncate_title']), "blog/show?blogid=".$blog->getBlogid()."&id=".$blog->getUid()) ?></h3>
          <?php if($params['show_user_info']): ?>
          <?php include_component('user', 'avatar', array('user' => $blog->getUser(), 'options' => array('size' => '80x80'), 'show_overlay' => false)); ?>
          <cite>
            <strong class="author"><?php echo $blog->getUser()->getLinkTo(null, array("class" => "autor")) ?></strong> &middot; <span class="date"><?php echo format_datetime($blog->getCreatedAt(null)) ?></span>
          </cite>
          <?php endif; ?>
          <?php if($params['show_info_line']): ?>
          <div class="infoLine">
            <?php echo __('by'); ?> <?php echo $blog->getUser()->getLinkTo(null, array("class" => "autor")) ?> - <?php echo format_date($blog->getCreatedAt(), 'p'); ?> - <span class="comments"><?php print $blog->countBlogComments(); ?></span>
          </div>
          <?php endif; ?>
          <?php echo truncate_text($blog->getDescription(), $params['truncate_descr']) ?>
          <?php if($params['show_more_link']): ?>
            <?php echo link_to(__('read more').' &raquo;', "blog/show?blogid=".$blog->getBlogid()."&id=".$blog->getUid(), array('class' => 'viewMore')); ?>
          <?php endif; ?>
        </div>
        <?php endforeach; ?>
        <?php if($params['show_all_link'] || ($params['show_pager'] && $new_blogs_pager->haveToPaginate())): ?>
        <div class="bottomLink">
          <?php if($params['show_pager']) : ?>
          <?php include_component('media', 'pager', array('no_param' => false, 'page_param_name' => $params['page_name'], 'pager' => $new_blogs_pager, 'link' => $link, 'ajaxLink' => $ajaxLink, 'id' => $params['container_id'], 'perPage' => $params['items_perpage'], 'caption' => $params['caption'], 'culture' => sfContext::getInstance()->getUser()->getCulture())); ?>
          <?php endif; ?>
          <?php if($params['show_all_link']): ?>
          <?php echo link_to(__('more'), is_string($params['show_all_link']) ? $params['show_all_link'] : 'blog/index', array('class'=>'more') ); ?>
          <?php endif; ?>
        </div>
      <?php endif; ?>
      <?php else: ?>
        <p class="empty"><?php echo __('No blog found.'); ?></p>
      <?php endif; ?>
    </div>
  </div>
